//
//  File.swift
//  EcoWarriors
//
//  Created by Ria on 14/08/19.
//  Copyright © 2019 Ria. All rights reserved.
//

import UIKit
import FSCalendar

class UEController: UIViewController{
    fileprivate weak var calendar: FSCalendar?
    
    
    //MARK:- viewDidLoad()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        

        pageSetup()

    }
    
    //MARK:- Page Setup
        var datesWithEvent = ["2021-01-09","2021-02-13","2021-03-13","2021-04-10", "2021-05-08", "2021-06-12"]

   

    fileprivate lazy var dateFormatter3: DateFormatter = {
        let formatter = DateFormatter()
        formatter.dateFormat = "yyyy-MM-dd"
        return formatter
    }()

    
    func calendar(_ calendar: FSCalendar, numberOfEventsFor date: Date) -> Int {

        let dateString = self.dateFormatter3.string(from: date)

        if self.datesWithEvent.contains(dateString) {
            return 1
        }

        return 0
    }
    
    func calendar(_ calendar: FSCalendar,didSelect date:Date,at monthPosition:FSCalendarMonthPosition) {
        let formatter = DateFormatter()
        formatter.dateFormat = "yyyy-MM-dd"
        let string = formatter.string(from: date)
        if string == "2021-01-09"{
            handlePress1() }
        if string == "2021-02-13"{
        handlePress2() }
        if string == "2021-03-13"{
        handlePress3() }
        if string == "2021-04-10"{
        handlePress4() }
        if string == "2021-05-08"{
        handlePress5() }
        if string == "2021-06-12"{
        handlePress6() }
        
    }
    func pageSetup() {
        
       
        
        let background = UILabel(frame: CGRect(x: 0, y: 0, width: screenWidth, height: 2000))
        background.center = CGPoint(x: screenWidth/2, y: 305)
        background.backgroundColor = .white
        self.view.addSubview(background)
    

        let calendar = FSCalendar(frame: CGRect(x: 20, y: 100, width: screenWidth-40, height: 400))
        calendar.dataSource = self
        calendar.delegate = self
        calendar.appearance.weekdayTextColor = UIColor.black
        calendar.appearance.headerTitleColor = UIColor.black
        calendar.register(FSCalendarCell.self, forCellReuseIdentifier: "CELL")
        view.addSubview(calendar)
        self.calendar = calendar
        
        let LogoUE = UIImageView()
                      LogoUE.image = #imageLiteral(resourceName: "UELogo.jpg")
                      LogoUE.frame = CGRect(x: screenWidth/2-150, y: 500, width: 300, height: 300)
                      LogoUE.layer.cornerRadius = 5
                      LogoUE.clipsToBounds = true
                      self.view.addSubview(LogoUE)
                    
                      let QuoteUE = UILabel()
                      QuoteUE.frame = CGRect(x: screenWidth/2+15, y: 420,width:100,height: 300)
                      QuoteUE.textAlignment = NSTextAlignment.center
                      QuoteUE.text = "don't be late ! "
                      QuoteUE.numberOfLines = 10
                      QuoteUE.lineBreakMode = .byWordWrapping
                      QuoteUE.textColor = .black
                      QuoteUE.font = UIFont(name: "HelveticaNeue-LightItalic", size: 25)
                      self.view.addSubview(QuoteUE)
        
        //MARK:- Navigation Bar
        
        self.navigationItem.title = "Upcoming events"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationController?.navigationBar.barStyle = .black
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))

    }
    
    @objc func handlePress1() {
        let controller = UINavigationController(rootViewController: Event1())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress2() {
        let controller = UINavigationController(rootViewController: Event2())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress3() {
        let controller = UINavigationController(rootViewController: Event3())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress4() {
        let controller = UINavigationController(rootViewController: Event4())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress5() {
        let controller = UINavigationController(rootViewController: Event5())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress6() {
        let controller = UINavigationController(rootViewController: Event6())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }


    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
    
    @objc func doNothing(_ sender:UIButton!) {
        
    }
    
    
}
extension UEController: FSCalendarDataSource,FSCalendarDelegate {
    func calendar(_ calendar: FSCalendar, cellFor date: Date, at position: FSCalendarMonthPosition) -> FSCalendarCell {
        let cell = calendar.dequeueReusableCell(withIdentifier: "CELL", for: date, at: position)
    return cell }
}


//MARK:- Event 1
class Event1: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "Meeting.jpeg")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        let line1 = UIButton()
        line1.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line1.center = CGPoint(x: screenWidth/2, y: 481)
        line1.backgroundColor = .gray
        line1.layer.cornerRadius = 1
        line1.clipsToBounds = true
        self.view.addSubview(line1)
        
        let line2 = UIButton()
               line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line2.center = CGPoint(x: screenWidth/2, y: 554)
               line2.backgroundColor = .gray
               line2.layer.cornerRadius = 1
               line2.clipsToBounds = true
               self.view.addSubview(line2)
        
      let line3 = UIButton()
             line3.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
             line3.center = CGPoint(x: screenWidth/2, y: 627)
             line3.backgroundColor = .gray
             line3.layer.cornerRadius = 1
             line3.clipsToBounds = true
             self.view.addSubview(line3)
      
               
               let line4 = UIButton()
               line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line4.center = CGPoint(x: screenWidth/2, y: 698)
               line4.backgroundColor = .gray
               line4.layer.cornerRadius = 1
               line4.clipsToBounds = true
               self.view.addSubview(line4)
               
               let phoneNumberImg = UIImage(named: "UM1")
               let phoneNumber = UIButton()
               phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
               phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
               phoneNumber.layer.cornerRadius = 20;
               phoneNumber.clipsToBounds = true
               self.view.addSubview(phoneNumber)
               
               let phoneLabel = UILabel()
               phoneLabel.frame = CGRect(x: 110, y: 430, width: 500, height: 40)
               phoneLabel.text = "09/01/2021 "
               phoneLabel.textColor = .black
               phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(phoneLabel)
               
               let emailImg = UIImage(named: "UM2")
               let Email = UIButton()
               Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
               Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
               Email.layer.cornerRadius = 20;
               Email.clipsToBounds = true
               self.view.addSubview(Email)
               
               let emailLabel = UILabel()
               emailLabel.frame = CGRect(x: 110, y: 497, width: 500, height: 40)
               emailLabel.text = "6:00 PM"
               emailLabel.textColor = .black
               emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(emailLabel)
               
               let AddressImg = UIImage(named: "stock")
               let Address = UIButton()
               Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
               Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
               Address.layer.cornerRadius = 20;
               Address.clipsToBounds = true
               self.view.addSubview(Address)
               
               let AddressLabel = UILabel()
               AddressLabel.frame = CGRect(x: 110, y: 569, width: 500, height: 40)
               AddressLabel.text = "Regular Meeting"
               AddressLabel.textColor = .black
               AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(AddressLabel)
               
               let InstaImg = UIImage(named: "Adress")
               let Insta = UIButton()
               Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
               Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
               Insta.layer.cornerRadius = 20;
               Insta.clipsToBounds = true
               self.view.addSubview(Insta)
               
               let instaLabel = UILabel()
               instaLabel.frame = CGRect(x: 110, y: 641, width: 500, height: 40)
               instaLabel.text = "Club house, Room 3"
               instaLabel.textColor = .black
               instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(instaLabel)
               
               let TwitterImg = UIImage(named: "U5")
               let Twitter = UIButton()
               Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
               Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
               Twitter.layer.cornerRadius = 20;
               Twitter.clipsToBounds = true
               self.view.addSubview(Twitter)
               
               let TwitterLabel = UILabel()
               TwitterLabel.frame = CGRect(x: 110, y: 713, width: 500, height: 40)
               TwitterLabel.text = "Core Team"
               TwitterLabel.textColor = .black
               TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Regular Metting"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
//MARK:- Event 2
class Event2: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "Photography-1")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        let line1 = UIButton()
        line1.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line1.center = CGPoint(x: screenWidth/2, y: 481)
        line1.backgroundColor = .gray
        line1.layer.cornerRadius = 1
        line1.clipsToBounds = true
        self.view.addSubview(line1)
        
        let line2 = UIButton()
               line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line2.center = CGPoint(x: screenWidth/2, y: 554)
               line2.backgroundColor = .gray
               line2.layer.cornerRadius = 1
               line2.clipsToBounds = true
               self.view.addSubview(line2)
        
      let line3 = UIButton()
             line3.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
             line3.center = CGPoint(x: screenWidth/2, y: 627)
             line3.backgroundColor = .gray
             line3.layer.cornerRadius = 1
             line3.clipsToBounds = true
             self.view.addSubview(line3)
      
               
               let line4 = UIButton()
               line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line4.center = CGPoint(x: screenWidth/2, y: 698)
               line4.backgroundColor = .gray
               line4.layer.cornerRadius = 1
               line4.clipsToBounds = true
               self.view.addSubview(line4)
               
               let phoneNumberImg = UIImage(named: "UM1")
               let phoneNumber = UIButton()
               phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
               phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
               phoneNumber.layer.cornerRadius = 20;
               phoneNumber.clipsToBounds = true
               self.view.addSubview(phoneNumber)
               
               let phoneLabel = UILabel()
               phoneLabel.frame = CGRect(x: 110, y: 430, width: 500, height: 40)
               phoneLabel.text = "13/02/2021"
               phoneLabel.textColor = .black
               phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(phoneLabel)
               
               let emailImg = UIImage(named: "UM2")
               let Email = UIButton()
               Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
               Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
               Email.layer.cornerRadius = 20;
               Email.clipsToBounds = true
               self.view.addSubview(Email)
               
               let emailLabel = UILabel()
               emailLabel.frame = CGRect(x: 110, y: 497, width: 500, height: 40)
               emailLabel.text = "6:00 PM"
               emailLabel.textColor = .black
               emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(emailLabel)
               
               let AddressImg = UIImage(named: "stock")
               let Address = UIButton()
               Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
               Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
               Address.layer.cornerRadius = 20;
               Address.clipsToBounds = true
               self.view.addSubview(Address)
               
               let AddressLabel = UILabel()
               AddressLabel.frame = CGRect(x: 110, y: 569, width: 500, height: 40)
               AddressLabel.text = "Photography Competition"
               AddressLabel.textColor = .black
               AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(AddressLabel)
               
               let InstaImg = UIImage(named: "Adress")
               let Insta = UIButton()
               Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
               Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
               Insta.layer.cornerRadius = 20;
               Insta.clipsToBounds = true
               self.view.addSubview(Insta)
               
               let instaLabel = UILabel()
               instaLabel.frame = CGRect(x: 110, y: 641, width: 500, height: 40)
               instaLabel.text = "T6, Phase 2"
               instaLabel.textColor = .black
               instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(instaLabel)
               
               let TwitterImg = UIImage(named: "U5")
               let Twitter = UIButton()
               Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
               Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
               Twitter.layer.cornerRadius = 20;
               Twitter.clipsToBounds = true
               self.view.addSubview(Twitter)
               
               let TwitterLabel = UILabel()
               TwitterLabel.frame = CGRect(x: 110, y: 713, width: 500, height: 40)
               TwitterLabel.text = "All residents"
               TwitterLabel.textColor = .black
               TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Photography Competition"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
//MARK:- Event 3
class Event3: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "Meeting.jpeg")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        let line1 = UIButton()
        line1.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line1.center = CGPoint(x: screenWidth/2, y: 481)
        line1.backgroundColor = .gray
        line1.layer.cornerRadius = 1
        line1.clipsToBounds = true
        self.view.addSubview(line1)
        
        let line2 = UIButton()
               line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line2.center = CGPoint(x: screenWidth/2, y: 554)
               line2.backgroundColor = .gray
               line2.layer.cornerRadius = 1
               line2.clipsToBounds = true
               self.view.addSubview(line2)
        
      let line3 = UIButton()
             line3.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
             line3.center = CGPoint(x: screenWidth/2, y: 627)
             line3.backgroundColor = .gray
             line3.layer.cornerRadius = 1
             line3.clipsToBounds = true
             self.view.addSubview(line3)
      
               
               let line4 = UIButton()
               line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line4.center = CGPoint(x: screenWidth/2, y: 698)
               line4.backgroundColor = .gray
               line4.layer.cornerRadius = 1
               line4.clipsToBounds = true
               self.view.addSubview(line4)
               
               let phoneNumberImg = UIImage(named: "UM1")
               let phoneNumber = UIButton()
               phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
               phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
               phoneNumber.layer.cornerRadius = 20;
               phoneNumber.clipsToBounds = true
               self.view.addSubview(phoneNumber)
               
               let phoneLabel = UILabel()
               phoneLabel.frame = CGRect(x: 110, y: 430, width: 500, height: 40)
               phoneLabel.text = "13/03/2021 "
               phoneLabel.textColor = .black
               phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(phoneLabel)
               
               let emailImg = UIImage(named: "UM2")
               let Email = UIButton()
               Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
               Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
               Email.layer.cornerRadius = 20;
               Email.clipsToBounds = true
               self.view.addSubview(Email)
               
               let emailLabel = UILabel()
               emailLabel.frame = CGRect(x: 110, y: 497, width: 500, height: 40)
               emailLabel.text = "6:00 PM"
               emailLabel.textColor = .black
               emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(emailLabel)
               
               let AddressImg = UIImage(named: "stock")
               let Address = UIButton()
               Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
               Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
               Address.layer.cornerRadius = 20;
               Address.clipsToBounds = true
               self.view.addSubview(Address)
               
               let AddressLabel = UILabel()
               AddressLabel.frame = CGRect(x: 110, y: 569, width: 500, height: 40)
               AddressLabel.text = "Regular Meeting"
               AddressLabel.textColor = .black
               AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(AddressLabel)
               
               let InstaImg = UIImage(named: "Adress")
               let Insta = UIButton()
               Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
               Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
               Insta.layer.cornerRadius = 20;
               Insta.clipsToBounds = true
               self.view.addSubview(Insta)
               
               let instaLabel = UILabel()
               instaLabel.frame = CGRect(x: 110, y: 641, width: 500, height: 40)
               instaLabel.text = "Club house, Room 3"
               instaLabel.textColor = .black
               instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(instaLabel)
               
               let TwitterImg = UIImage(named: "U5")
               let Twitter = UIButton()
               Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
               Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
               Twitter.layer.cornerRadius = 20;
               Twitter.clipsToBounds = true
               self.view.addSubview(Twitter)
               
               let TwitterLabel = UILabel()
               TwitterLabel.frame = CGRect(x: 110, y: 713, width: 500, height: 40)
               TwitterLabel.text = "Core Team"
               TwitterLabel.textColor = .black
               TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Regular Metting"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
//MARK:- Event 4
class Event4: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "Relay Race")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        let line1 = UIButton()
        line1.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line1.center = CGPoint(x: screenWidth/2, y: 481)
        line1.backgroundColor = .gray
        line1.layer.cornerRadius = 1
        line1.clipsToBounds = true
        self.view.addSubview(line1)
        
        let line2 = UIButton()
               line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line2.center = CGPoint(x: screenWidth/2, y: 554)
               line2.backgroundColor = .gray
               line2.layer.cornerRadius = 1
               line2.clipsToBounds = true
               self.view.addSubview(line2)
        
      let line3 = UIButton()
             line3.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
             line3.center = CGPoint(x: screenWidth/2, y: 627)
             line3.backgroundColor = .gray
             line3.layer.cornerRadius = 1
             line3.clipsToBounds = true
             self.view.addSubview(line3)
      
               
               let line4 = UIButton()
               line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line4.center = CGPoint(x: screenWidth/2, y: 698)
               line4.backgroundColor = .gray
               line4.layer.cornerRadius = 1
               line4.clipsToBounds = true
               self.view.addSubview(line4)
               
               let phoneNumberImg = UIImage(named: "UM1")
               let phoneNumber = UIButton()
               phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
               phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
               phoneNumber.layer.cornerRadius = 20;
               phoneNumber.clipsToBounds = true
               self.view.addSubview(phoneNumber)
               
               let phoneLabel = UILabel()
               phoneLabel.frame = CGRect(x: 110, y: 430, width: 500, height: 40)
               phoneLabel.text = "10/04/2021"
               phoneLabel.textColor = .black
               phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(phoneLabel)
               
               let emailImg = UIImage(named: "UM2")
               let Email = UIButton()
               Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
               Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
               Email.layer.cornerRadius = 20;
               Email.clipsToBounds = true
               self.view.addSubview(Email)
               
               let emailLabel = UILabel()
               emailLabel.frame = CGRect(x: 110, y: 497, width: 500, height: 40)
               emailLabel.text = "10:00 AM"
               emailLabel.textColor = .black
               emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(emailLabel)
               
               let AddressImg = UIImage(named: "stock")
               let Address = UIButton()
               Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
               Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
               Address.layer.cornerRadius = 20;
               Address.clipsToBounds = true
               self.view.addSubview(Address)
               
               let AddressLabel = UILabel()
               AddressLabel.frame = CGRect(x: 110, y: 569, width: 500, height: 40)
               AddressLabel.text = "Relay Race"
               AddressLabel.textColor = .black
               AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(AddressLabel)
               
               let InstaImg = UIImage(named: "Adress")
               let Insta = UIButton()
               Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
               Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
               Insta.layer.cornerRadius = 20;
               Insta.clipsToBounds = true
               self.view.addSubview(Insta)
               
               let instaLabel = UILabel()
               instaLabel.frame = CGRect(x: 110, y: 641, width: 500, height: 40)
               instaLabel.text = "Phase 2 Park"
               instaLabel.textColor = .black
               instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(instaLabel)
               
               let TwitterImg = UIImage(named: "U5")
               let Twitter = UIButton()
               Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
               Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
               Twitter.layer.cornerRadius = 20;
               Twitter.clipsToBounds = true
               self.view.addSubview(Twitter)
               
               let TwitterLabel = UILabel()
               TwitterLabel.frame = CGRect(x: 110, y: 713, width: 500, height: 40)
               TwitterLabel.text = "All residents"
               TwitterLabel.textColor = .black
               TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Relay Race"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
//MARK:- Event 5
class Event5: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "Meeting")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        let line1 = UIButton()
        line1.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line1.center = CGPoint(x: screenWidth/2, y: 481)
        line1.backgroundColor = .gray
        line1.layer.cornerRadius = 1
        line1.clipsToBounds = true
        self.view.addSubview(line1)
        
        let line2 = UIButton()
               line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line2.center = CGPoint(x: screenWidth/2, y: 554)
               line2.backgroundColor = .gray
               line2.layer.cornerRadius = 1
               line2.clipsToBounds = true
               self.view.addSubview(line2)
        
      let line3 = UIButton()
             line3.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
             line3.center = CGPoint(x: screenWidth/2, y: 627)
             line3.backgroundColor = .gray
             line3.layer.cornerRadius = 1
             line3.clipsToBounds = true
             self.view.addSubview(line3)
      
               
               let line4 = UIButton()
               line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line4.center = CGPoint(x: screenWidth/2, y: 698)
               line4.backgroundColor = .gray
               line4.layer.cornerRadius = 1
               line4.clipsToBounds = true
               self.view.addSubview(line4)
               
               let phoneNumberImg = UIImage(named: "UM1")
               let phoneNumber = UIButton()
               phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
               phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
               phoneNumber.layer.cornerRadius = 20;
               phoneNumber.clipsToBounds = true
               self.view.addSubview(phoneNumber)
               
               let phoneLabel = UILabel()
               phoneLabel.frame = CGRect(x: 110, y: 430, width: 500, height: 40)
               phoneLabel.text = "8/05/2021 "
               phoneLabel.textColor = .black
               phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(phoneLabel)
               
               let emailImg = UIImage(named: "UM2")
               let Email = UIButton()
               Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
               Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
               Email.layer.cornerRadius = 20;
               Email.clipsToBounds = true
               self.view.addSubview(Email)
               
               let emailLabel = UILabel()
               emailLabel.frame = CGRect(x: 110, y: 497, width: 500, height: 40)
               emailLabel.text = "6:00 PM"
               emailLabel.textColor = .black
               emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(emailLabel)
               
               let AddressImg = UIImage(named: "stock")
               let Address = UIButton()
               Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
               Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
               Address.layer.cornerRadius = 20;
               Address.clipsToBounds = true
               self.view.addSubview(Address)
               
               let AddressLabel = UILabel()
               AddressLabel.frame = CGRect(x: 110, y: 569, width: 500, height: 40)
               AddressLabel.text = "Regular Meeting"
               AddressLabel.textColor = .black
               AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(AddressLabel)
               
               let InstaImg = UIImage(named: "Adress")
               let Insta = UIButton()
               Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
               Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
               Insta.layer.cornerRadius = 20;
               Insta.clipsToBounds = true
               self.view.addSubview(Insta)
               
               let instaLabel = UILabel()
               instaLabel.frame = CGRect(x: 110, y: 641, width: 500, height: 40)
               instaLabel.text = "Club house, Room 3"
               instaLabel.textColor = .black
               instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(instaLabel)
               
               let TwitterImg = UIImage(named: "U5")
               let Twitter = UIButton()
               Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
               Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
               Twitter.layer.cornerRadius = 20;
               Twitter.clipsToBounds = true
               self.view.addSubview(Twitter)
               
               let TwitterLabel = UILabel()
               TwitterLabel.frame = CGRect(x: 110, y: 713, width: 500, height: 40)
               TwitterLabel.text = "Core Team"
               TwitterLabel.textColor = .black
               TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Regular Metting"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
//MARK:- Event 6
class Event6: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "Community picnic")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        let line1 = UIButton()
        line1.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line1.center = CGPoint(x: screenWidth/2, y: 481)
        line1.backgroundColor = .gray
        line1.layer.cornerRadius = 1
        line1.clipsToBounds = true
        self.view.addSubview(line1)
        
        let line2 = UIButton()
               line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line2.center = CGPoint(x: screenWidth/2, y: 554)
               line2.backgroundColor = .gray
               line2.layer.cornerRadius = 1
               line2.clipsToBounds = true
               self.view.addSubview(line2)
        
      let line3 = UIButton()
             line3.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
             line3.center = CGPoint(x: screenWidth/2, y: 627)
             line3.backgroundColor = .gray
             line3.layer.cornerRadius = 1
             line3.clipsToBounds = true
             self.view.addSubview(line3)
      
               
               let line4 = UIButton()
               line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line4.center = CGPoint(x: screenWidth/2, y: 698)
               line4.backgroundColor = .gray
               line4.layer.cornerRadius = 1
               line4.clipsToBounds = true
               self.view.addSubview(line4)
               
               let phoneNumberImg = UIImage(named: "UM1")
               let phoneNumber = UIButton()
               phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
               phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
               phoneNumber.layer.cornerRadius = 20;
               phoneNumber.clipsToBounds = true
               self.view.addSubview(phoneNumber)
               
               let phoneLabel = UILabel()
               phoneLabel.frame = CGRect(x: 110, y: 430, width: 500, height: 40)
               phoneLabel.text = "12/06/2021"
               phoneLabel.textColor = .black
               phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(phoneLabel)
               
               let emailImg = UIImage(named: "UM2")
               let Email = UIButton()
               Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
               Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
               Email.layer.cornerRadius = 20;
               Email.clipsToBounds = true
               self.view.addSubview(Email)
               
               let emailLabel = UILabel()
               emailLabel.frame = CGRect(x: 110, y: 497, width: 500, height: 40)
               emailLabel.text = "10:00 AM"
               emailLabel.textColor = .black
               emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(emailLabel)
               
               let AddressImg = UIImage(named: "stock")
               let Address = UIButton()
               Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
               Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
               Address.layer.cornerRadius = 20;
               Address.clipsToBounds = true
               self.view.addSubview(Address)
               
               let AddressLabel = UILabel()
               AddressLabel.frame = CGRect(x: 110, y: 569, width: 500, height: 40)
               AddressLabel.text = "Community picnic"
               AddressLabel.textColor = .black
               AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(AddressLabel)
               
               let InstaImg = UIImage(named: "Adress")
               let Insta = UIButton()
               Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
               Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
               Insta.layer.cornerRadius = 20;
               Insta.clipsToBounds = true
               self.view.addSubview(Insta)
               
               let instaLabel = UILabel()
               instaLabel.frame = CGRect(x: 110, y: 641, width: 500, height: 40)
               instaLabel.text = "Phase 2 Park"
               instaLabel.textColor = .black
               instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(instaLabel)
               
               let TwitterImg = UIImage(named: "U5")
               let Twitter = UIButton()
               Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
               Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
               Twitter.layer.cornerRadius = 20;
               Twitter.clipsToBounds = true
               self.view.addSubview(Twitter)
               
               let TwitterLabel = UILabel()
               TwitterLabel.frame = CGRect(x: 110, y: 713, width: 500, height: 40)
               TwitterLabel.text = "All residents"
               TwitterLabel.textColor = .black
               TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 20)
               self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Community picnic"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
